define(['app', 'angular', 'moment'], function (app, angular, moment) {
	app.directive('listTable', function () {
		return {
			restrict: 'AE',
			scope: {
				'listItems' : '=',
				'headers' : '=',
				'rows' : '=',
				'onItemClick' : '&',
                'resultsMessage' : '=',
				'noResultsMessage' : '=',
				'noUnfilteredResultsTemplate' : '=',
				'unfilteredItemCount': '='
			},
			controller : function($scope, $parse){
				$scope.getDeepObjectValue = function(item, header) {
					var val = $parse(header.keys)(item);
					if(!angular.isUndefined(header.ifNull)) {
						return val || header.ifNull;
					}
					return val;
				};

				$scope.isValueNull = function(item, header) {
					var value = $scope.getDeepObjectValue(item, header);
					return !(value || value === 0);
				};

				$scope.formatDate = function (date) {
					return moment(new Date(date)).format('MM/DD/YYYY hh:mm A');
				};
			},
			templateUrl: function(elem, attr) {
				return attr.useCellPartials ? 'src/ui-components/table/table-with-cell-partials_template.html' : 'src/ui-components/table/table_template.html';
			}
		};
	});
});